import { Injectable } from '@angular/core';
import { BehaviorSubject } from 'rxjs';

export const THEMES = [
  'light',
  'cupcake',
  'bumblebee',
  'emerald',
  'corporate',
  'retro',
  'cyberpunk',
  'valentine',
  'garden',
  'aqua',
  'lofi',
  'pastel',
  'fantasy',
  'wireframe',
  'cmyk',
  'autumn',
  'acid',
  'lemonade',
  'winter',
  'sunset',
];

@Injectable({
  providedIn: 'root',
})
export class ThemeService {
  private currentThemeSubject = new BehaviorSubject<string>('light');
  public currentTheme$ = this.currentThemeSubject.asObservable();

  constructor() {
    // Load theme from localStorage on initialization
    const savedTheme = localStorage.getItem('cricket-theme') || 'light';
    this.setTheme(savedTheme);
  }

  getCurrentTheme(): string {
    return this.currentThemeSubject.value;
  }

  setTheme(theme: string): void {
    if (THEMES.includes(theme)) {
      localStorage.setItem('cricket-theme', theme);
      this.currentThemeSubject.next(theme);
      this.applyTheme(theme);
    }
  }

  private applyTheme(theme: string): void {
    // Apply theme to document
    document.documentElement.setAttribute('data-theme', theme);
  }
}
