import { Component, OnInit } from '@angular/core';
import { ThemeService, THEMES } from '../../services/theme';

@Component({
  selector: 'app-settings',
  standalone: false,
  templateUrl: './settings.html',
  styleUrl: './settings.css',
})
export class Settings implements OnInit {
  currentTheme = 'light';
  themes = THEMES;

  constructor(private themeService: ThemeService) {}

  ngOnInit() {
    this.currentTheme = this.themeService.getCurrentTheme();
  }

  setTheme(theme: string) {
    this.themeService.setTheme(theme);
    this.currentTheme = theme;
  }
}
