import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { CricketService, Match } from '../../services/cricket';

@Component({
  selector: 'app-match-list',
  templateUrl: './match-list.html',
  styleUrls: ['./match-list.css'],
  standalone: false,
})
export class MatchList implements OnInit {
  matches: Match[] = [];
  loading = true;
  error = '';

  constructor(private cricketService: CricketService, private router: Router) {}

  ngOnInit() {
    this.loadMatches();
  }

  loadMatches() {
    this.loading = true;
    this.error = '';

    this.cricketService.getAllMatches().subscribe({
      next: (response) => {
        if (response.success) {
          this.matches = response.data;
        } else {
          this.error = 'Failed to load matches';
        }
        this.loading = false;
      },
      error: (err) => {
        this.error = 'Error connecting to server: ' + err.message;
        this.loading = false;
      },
    });
  }

  viewMatchDetails(matchId: string) {
    this.router.navigate(['/match', matchId]);
  }
}
