import { Component, signal, OnInit, AfterViewInit } from '@angular/core';
import { initFlowbite } from 'flowbite';
import { ThemeService } from './services/theme';

@Component({
  selector: 'app-root',
  templateUrl: './app.html',
  standalone: false,
  styleUrl: './app.css',
})
export class App implements OnInit, AfterViewInit {
  protected readonly title = signal('frontend');
  isMobileMenuOpen = false;

  constructor(private themeService: ThemeService) {}

  ngOnInit() {
    // Initialize theme service (this will load saved theme from localStorage)
    this.themeService.getCurrentTheme();
  }

  ngAfterViewInit() {
    // Initialize Flowbite components
    initFlowbite();
  }

  toggleMobileMenu() {
    this.isMobileMenuOpen = !this.isMobileMenuOpen;
  }

  closeMobileMenu() {
    this.isMobileMenuOpen = false;
  }
}
