import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { Home } from './components/home/home';
import { MatchList } from './components/match-list/match-list';
import { MatchDetails } from './components/match-details/match-details';
import { MatchUpload } from './components/match-upload/match-upload';
import { Settings } from './components/settings/settings';

const routes: Routes = [
  { path: '', component: Home },
  { path: 'home', component: Home },
  { path: 'matches', component: MatchList },
  { path: 'match/:id', component: MatchDetails },
  { path: 'upload', component: MatchUpload },
  { path: 'settings', component: Settings },
  { path: '**', redirectTo: '' },
];

@NgModule({
  imports: [RouterModule.forRoot(routes)],
  exports: [RouterModule],
})
export class AppRoutingModule {}
