import { NgModule, provideBrowserGlobalErrorListeners } from '@angular/core';
import { BrowserModule } from '@angular/platform-browser';
import { HttpClientModule } from '@angular/common/http';

import { App } from './app';
import { MatchList } from './components/match-list/match-list';
import { MatchDetails } from './components/match-details/match-details';
import { MatchVisualization } from './components/match-visualization/match-visualization';
import { Home } from './components/home/home';
import { MatchUpload } from './components/match-upload/match-upload';
import { AppRoutingModule } from './app-routing-module';
import { Footer } from './components/footer/footer';
import { Settings } from './components/settings/settings';
import { Loading } from './components/loading/loading';

@NgModule({
  declarations: [App, MatchList, MatchDetails, MatchVisualization, Home, MatchUpload, Footer, Settings, Loading],
  imports: [BrowserModule, HttpClientModule, AppRoutingModule],
  providers: [provideBrowserGlobalErrorListeners()],
  bootstrap: [App],
})
export class AppModule {}
