const express = require('express');
const router = express.Router();
const matchController = require('../controllers/matchController');

// POST /api/addMatchInfo - Add new match data
router.post('/addMatchInfo', matchController.addMatchInfo);

// GET /api/getMatchInfo/:matchId - Get processed match scorecard
router.get('/getMatchInfo/:matchId', matchController.getMatchInfo);

// GET /api/matches - Get all matches 
router.get('/matches', matchController.getAllMatches);

// GET /api/rawMatch/:matchId - Get raw match JSON data
router.get('/rawMatch/:matchId', matchController.getRawMatchData);

module.exports = router;
