# Cricket Match Data API

A Cricinfo-style match report system built with Node.js and Express.js.

## 🏏 Features

- **Add Match Data**: Store complete cricket match data from JSON files
- **Get Match Scorecard**: Retrieve processed match statistics and scorecard
- **Web Scorecard**: View match scorecard in a beautiful web interface
- **File-based Storage**: Simple JSON file storage (no database required)

## 🚀 Quick Start

### Installation

```bash
cd backend
npm install
```

### Environment Setup

Create a `.env` file:
```
PORT=3000
NODE_ENV=development
```

### Start Server

```bash
npm start
# or for development
npm run dev
```

The server will start on `http://localhost:3000`

## 📡 API Endpoints

### 1. Add Match Data
**POST** `/api/addMatchInfo`

Add new cricket match data to the system.

**Request Body**: Complete cricket match JSON (following the provided schema)

**Response**:
```json
{
  "success": true,
  "message": "Match data saved successfully",
  "matchId": "uuid-here"
}
```

### 2. Get Match Scorecard
**GET** `/api/getMatchInfo/:matchId`

Get processed match scorecard data.

**Response**:
```json
{
  "success": true,
  "data": {
    "matchInfo": {
      "teams": ["Team1", "Team2"],
      "date": "2023-10-31",
      "venue": "Stadium Name",
      "winner": "Team1",
      "result": { "wickets": 7 }
    },
    "innings": [
      {
        "team": "Team1",
        "totalRuns": 300,
        "totalWickets": 5,
        "totalOvers": "50.0",
        "playerStats": [...]
      }
    ]
  }
}
```

### 3. Get All Matches
**GET** `/api/matches`

Get list of all stored matches.

### 4. Web Scorecard
**GET** `/api/scorecard/:matchId`

View match scorecard in a beautiful web interface.

## 🏗️ Project Structure

```
backend/
├── controllers/
│   └── matchController.js    # Business logic for match operations
├── models/
│   └── matchModel.js         # Data storage and retrieval
├── routers/
│   └── matchRouter.js        # API route definitions
├── data/
│   └── matches.json          # File-based storage (auto-created)
├── server.js                 # Main server file
├── package.json
└── .env
```

## 🎯 Usage Examples

### Add a Match
```bash
curl -X POST http://localhost:3000/api/addMatchInfo \
  -H "Content-Type: application/json" \
  -d @match-data.json
```

### Get Match Scorecard
```bash
curl http://localhost:3000/api/getMatchInfo/match-id-here
```

### View Web Scorecard
Open in browser: `http://localhost:3000/api/scorecard/match-id-here`

## 🔧 Technical Details

- **Framework**: Express.js
- **Storage**: File-based JSON storage
- **Logging**: Morgan for HTTP request logging
- **CORS**: Enabled for cross-origin requests
- **Body Limit**: 50MB for large match data files

## 📊 Data Processing

The system processes raw ball-by-ball cricket data into:
- Match summary statistics
- Player batting statistics
- Inning-wise scorecards
- Match result information

## 🎨 Web Interface

The scorecard webpage includes:
- Match details and result
- Inning-wise statistics
- Player batting performance
- Responsive design
- Real-time data loading

## 🚀 Development

The code is structured for beginner to intermediate developers with:
- Clear separation of concerns
- Modular architecture
- Error handling
- Comprehensive logging
- Simple file-based storage
